function outA1 = affineAnnotations(A1, tform)
%AFFINEANNOTATIONS Summary of this function goes here
%   Detailed explanation goes here
    outA1 = zeros(size(A1));
    for r = 1:size(A1,1)
        % find top left corner
        w = A1(r,4);
        h = A1(r,5);
        left = (A1(r,2) - w/2) - 0.5;
        top = (A1(r,3) - h/2) - 0.5;
        right = (A1(r,2) + w/2) - 0.5;
        bottom = (A1(r,3) + h/2) - 0.5;
        [x1, y1] = transformPointsForward(tform, left, top);
        [x2, y2] = transformPointsForward(tform, right, bottom);
        [x3, y3] = transformPointsForward(tform, left, bottom);
        [x4, y4] = transformPointsForward(tform, right, top);
        cx = (x1 + x2)/2 + 0.5;
        cy = (y1 + y2)/2 + 0.5;
        w = max([x1, x2, x3, x4])- min([x1, x2, x3, x4]);
        h = max([y1, y2, y3, y4])- min([y1, y2, y3, y4]);
        outA1(r,:) = [A1(r,1),cx, cy, w, h];
    end
end

